# Generated by Django 5.1.7 on 2025-04-21 09:22

from decimal import Decimal
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('units', '0002_remove_unitbill_total_bill_and_more'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='unit',
            name='electricity_meter',
        ),
        migrations.RemoveField(
            model_name='unit',
            name='monthly_charge',
        ),
        migrations.RemoveField(
            model_name='unit',
            name='services',
        ),
        migrations.RemoveField(
            model_name='unit',
            name='water_meter',
        ),
        migrations.AddField(
            model_name='unit',
            name='current_electricity_reading',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=10, verbose_name='Current Electricity Meter Reading'),
        ),
        migrations.AddField(
            model_name='unit',
            name='current_water_reading',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=10, verbose_name='Current Water Meter Reading'),
        ),
        migrations.AddField(
            model_name='unit',
            name='monthly_base_charge',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), help_text='Fixed monthly rent or service fee, excluding usage.', max_digits=12, verbose_name='Monthly Base Charge'),
        ),
        migrations.AddField(
            model_name='unit',
            name='previous_electricity_reading',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=10, verbose_name='Previous Electricity Meter Reading'),
        ),
        migrations.AddField(
            model_name='unit',
            name='previous_water_reading',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=10, verbose_name='Previous Water Meter Reading'),
        ),
        migrations.AddField(
            model_name='unit',
            name='unit_description',
            field=models.TextField(blank=True, null=True, verbose_name='Unit Description'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='status',
            field=models.CharField(choices=[('Occupied', 'Occupied'), ('Vacant', 'Vacant'), ('Maintenance', 'Maintenance')], default='Vacant', max_length=50, verbose_name='Status'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='unit_count',
            field=models.PositiveIntegerField(default=1, verbose_name='Unit Count/Size'),
        ),
        migrations.AlterField(
            model_name='unit',
            name='unit_number',
            field=models.CharField(max_length=100, unique=True, verbose_name='Unit Number/Name'),
        ),
        migrations.AlterField(
            model_name='unitbill',
            name='total_billed',
            field=models.DecimalField(decimal_places=2, default=Decimal('0.00'), max_digits=14, verbose_name='Total Billed Amount'),
        ),
        migrations.AlterField(
            model_name='unitbill',
            name='unit_details',
            field=models.JSONField(default=dict, verbose_name='Unit Bill Details'),
        ),
    ]
