# Generated by Django 5.1.7 on 2025-05-07 11:28

from decimal import Decimal
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Expenditure',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('floor', models.CharField(choices=[('Second Floor', 'Second Floor'), ('Third Floor', 'Third Floor'), ('Fourth Floor', 'Fourth Floor'), ('general', 'general'), ('Other', 'Other')], max_length=20)),
                ('amount', models.DecimalField(decimal_places=2, default=Decimal('0.0'), max_digits=12)),
                ('year', models.CharField(max_length=4)),
                ('description', models.TextField()),
                ('month', models.PositiveSmallIntegerField(choices=[(1, 'حمل'), (2, 'ثور'), (3, 'جوزا'), (4, 'سرطان'), (5, 'اسد'), (6, 'سنبله'), (7, 'میزان'), (8, 'عقرب'), (9, 'قوس'), (10, 'جدی'), (11, 'دلو'), (12, 'حوت')], verbose_name='Month')),
                ('receiver', models.CharField(max_length=255)),
                ('consumer', models.CharField(blank=True, max_length=255, null=True, verbose_name='Consumer/Spender')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['-year', '-month', '-created_at'],
            },
        ),
        migrations.CreateModel(
            name='Income',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source', models.CharField(max_length=550)),
                ('amount', models.DecimalField(decimal_places=2, default=Decimal('0.0'), max_digits=12)),
                ('description', models.TextField(blank=True)),
                ('year', models.CharField(max_length=4)),
                ('month', models.PositiveSmallIntegerField(choices=[(1, 'حمل'), (2, 'ثور'), (3, 'جوزا'), (4, 'سرطان'), (5, 'اسد'), (6, 'سنبله'), (7, 'میزان'), (8, 'عقرب'), (9, 'قوس'), (10, 'جدی'), (11, 'دلو'), (12, 'حوت')], verbose_name='Month')),
                ('receiver', models.CharField(max_length=255)),
                ('consumer', models.CharField(blank=True, max_length=255, null=True, verbose_name='Payer/Recorded By')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ['-year', '-month', '-created_at'],
            },
        ),
    ]
