from rest_framework import serializers

from .models import Expenditure, Income


class ExpenditureSerializer(serializers.ModelSerializer):
    total_amount = serializers.SerializerMethodField()

    class Meta:
        model = Expenditure
        fields = [
            "id",
            "floor",
            "amount",
            "description",
            "month",
            "year",
            "receiver",
            "total_amount",
            "created_at",
            "updated_at",
        ]

    def get_total_amount(self, obj):
  
        total = (
            Expenditure.calculate_total_amount()
        )  
        return total


class IncomeSerializer(serializers.ModelSerializer):
    total_amount = serializers.SerializerMethodField()

    class Meta:
        model = Income
        fields = [
            "id",
            "source",
            "amount",
            "description",
            "month",
            "year",
            "receiver",
            "total_amount",
            "created_at",
            "updated_at",
        ]

    def get_total_amount(self, obj):
        total = Income.calculate_total_amount()
        return total
