# serializers.py
from rest_framework import serializers
from .models import Customer

class CustomerSerializer(serializers.ModelSerializer):
    image = serializers.ImageField(use_url=True, required=False, allow_null=True)

    class Meta:
        model = Customer
        fields = [
            "id",
            "name",
            "father_name",
            "phone_number",
            "image",
            "rental_owner",
            "nic",
            "address",
        ]
       
